/********************* (C) COPYRIGHT 2010 e-Design Co.,Ltd. ********************
 File Name : Draw.h  
 Version   : DS203_APP Ver 2.3x                                  Author : bure
*******************************************************************************/
#ifndef __DRAW_H
#define __DRAW_H

#include "stm32f10x_lib.h"

typedef struct 
{
  s16  Value;
  u8   Flag;       // HID=0x04, UPDAT=0x02, 
} trigg; 

//------------------- ĻʾɫŶ ----------------------
#define TR_1       0
#define TR_2       1
#define TR_3       2
#define TR_4       3
#define TR_1_      4
#define TR_2_      5
#define TR_3_      6
#define TR_4_      7
#define SCRN       8        //BLACK= 8   
#define NOTE1      9        //RED
#define VERNIE     10       //WHT
#define TEXT2      11       //GRN
#define TEXT3      4				//

#define GRID       13
#define X_POSI     14
//#define DARK       15
//#define NOTE3      8
#define TEXT1      10     //WHT
//#define BLOCK      8
#define SIDE       1        //YEL


#define SINE       0
#define TRIANG     1
#define SAW        2
#define DIGI       3

#define PRN        0   // No inverse Display
#define INV        1   // Inverse Display


#define WHT        0xFFFF
#define CYAN       0xFFE0
#define CYAN_      0xBDE0
#define YEL        0x07FF
#define YEL_       0x05F7
#define PURPL      0xF81F
#define PURPL_     0xB817
#define GRN        0x07E0
#define GRN_       0x05E0
#define GRAY       0x7BEF   
#define DARK       0x39E7   
#define BLUE       0xF800
#define ORANGE     0x051F
#define RED        0x001F
#define BLACK      0x0000


#define LCD_X1      0
#define LCD_X2      399
#define LCD_Y1      0
#define LCD_Y2      239
#define X_SIZE      360
#define X_BASE      0
#define Y_SIZE      200
#define Y_BASE      0
#define MIN_X       11
#define MIN_Y       13
#define MAX_X       (X_SIZE + MIN_X)
#define MAX_Y       (Y_SIZE + MIN_Y)

#define T0_POSI			90
extern u8  Vt_HIDE,V1_HIDE,V2_HIDE,T0_HIDE,T1_HIDE,T2_HIDE;                            // V1,V2αʾ/־
  
extern u16 VtColor,Vt,Vv1,Vv2;        // źԴɫ, ƽ־λ
extern u16 T0Posi, T1Posi,T2Posi,T0_PerCnt;     //ˮƽλ,T1αλ,T2αλ
                                                
extern u8  BLOCK_HIDE;
extern u32 Block[1500];
extern uc8 Ref_Wave [360];
extern u16 Palette[16], Nx0, Ny0;
extern s16 Bx1, Bx2, By1, By2;;
//extern u16 LCD_Buffer1[240], LCD_Buffer2[240];
extern trigg V_Trigg[4];
u16  Get_TAB_8x11(u8 Code, u8 Row);
u8   Get_Ref_Wave(u16 i);
extern u8  Show[4];
void Print_Clk(u16 x0, u16 y0, u16 Type, u8 Phase);
//void Print_Str(u16 x0, u16 y0, u16 Color, u8 Mode, u8 *s);
//void Draw_Row(u16 Row);
void Draw_Mark(u16 m, u16 n);						
void Update_Mark(void);						
void Update_View_Area(void);

void Draw_Window(void);						
void NotePixl(u8 HueNum);
void NoteChar(u8 HueNum, u8 Inv, u8 Char);
void NoteSTR(u8 HueNum, u8 Inv, u8 *s);
void NoteSide(u8 HueNum);
void Print_Char(u16 x0, u16 y0, u8 HueNum, u8 Inv, u8 Char);
void Print_Str(u16 x0, u16 y0, u8 HueNum, u8 Inv, u8 *s);
void Print_Map(u16 x0, u16 y0, u8 HueNum, u8 Inv, u8 Char);
void Print_CharMap(u16 x0, u16 y0, u8 HueNum, u8 Inv, u8 Char);
#endif

/********************************* END OF FILE ********************************/
